﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.IO;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
//using Microsoft.Security.Application;
public partial class DoDFragmentRawData : BasePage
{

    protected readonly string PatientWorkflowsPage = "PatientWorkflows.aspx?patientId=";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DisplayPatientInfo();
            DisplayLabReportDetails();
            HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);

            int patientId = Convert.ToInt32(HiddenFieldPatientID.Value);
            DataTable filesList = GetDoDFragmentFiles(patientId);

            GridViewEFRFragmentsRawData.DataSource = filesList;
            GridViewEFRFragmentsRawData.DataBind();

            //int numResults = filesList.Rows.Count;
        }
    }

    private void DisplayPatientInfo()
    {
        if (!string.IsNullOrEmpty(Request.QueryString["patientId"]))
        {
            int patientId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false));
            PatientManager patientManager = new PatientManager();
            PATIENT patient = patientManager.SelectByPatientID(patientId);

            if (patient != null)
            {
                BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > Display Source DoD Fragment Data > " + patient.FullName;
            }
        }
    }
    private void DisplayLabReportDetails()
    {
    }

    public DataTable GetDoDFragmentFiles(int patientId)
    {
        DataTable dataTable = new DataTable();

        try
        {
            dataTable = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString",
                "dbo.usp_EFR_GetDoDFragmentFilesByPatientId",
                new object[] { patientId
                    //Session["ReportDoDFragment.sortColumn"].ToString(),
                    //Session["ReportDoDFragment.sortOrder"].ToString(),
                    //TextBoxSearchCriteria.Text.Trim()
                 });
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Error processing new referral", ex);
        }

        return dataTable;
    }

    public void FragmentsRawData_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRFragmentsRawData.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRFragmentsRawData.SelectedValue);

            DoDFragmentManager manager = new DoDFragmentManager();
            DOD_FRAGMENT_RAW_DATA file = manager.SelectByRawDataId(id);

            Response.ContentType = "application/x-unknown";
            Response.AppendHeader("Content-Disposition", "attachment; filename=\"" + file.ORIGINAL_NAME + "\"");
            Response.BinaryWrite((byte[])file.FILE_DATA.ToArray());
        }

    }

    public string DisplayFormatDate(DateTime? date)
    {
        if (date.HasValue)
            return date.Value.ToString("d");

        else
            return "";
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    protected void ButtonBack_Click(object sender, EventArgs e)
    {
       // Response.Redirect(String.Format("PatientWorkflows.aspx?patientId={0}", GetValidStringValue(HiddenFieldPatientID.Value)));
        ResponseRedirect(PatientWorkflowsPage, GetValidStringValue(HiddenFieldPatientID.Value));
    }

    private string GetValidStringValue(string pCurrentValue)
    {
        string currentValue = string.Empty;
        if (pCurrentValue != null)
        {
            if (Regex.IsMatch(pCurrentValue, "^[a-zA-Z0-9]*$"))
            {
                currentValue = pCurrentValue;
            }
        }
        return currentValue;
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        try
        {
            string queryStringValue = string.Empty;
            if (queryString != null)
            {
                queryStringValue = AntiXssEncoder.UrlEncode(queryString);
            }

            string destinationUrl = string.Concat(destination, queryStringValue);
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                //Response.Redirect(destinationUrl);
                Server.Transfer(destinationUrl);
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in to redirect to: - PatientWorkflows page.");
        }

    }
}
